USE AdventureWorks2016;
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
GO

IF NOT EXISTS (SELECT * FROM sys.tables WHERE tables.name = 'Dimension_Table_Metadata')
BEGIN
	CREATE TABLE dbo.Dimension_Table_Metadata
	(	Dimension_ID SMALLINT IDENTITY(1,1) NOT NULL CONSTRAINT PK_Dimension_Table_Metadata PRIMARY KEY CLUSTERED,
		Target_Dimension_Table_Name VARCHAR(50) NOT NULL,
		Source_Fact_Schema_Name VARCHAR(128) NOT NULL,
		Source_Fact_Table_Name VARCHAR(128) NOT NULL,
		Source_Fact_Column_Name VARCHAR(50) NOT NULL
	);
END
GO

TRUNCATE TABLE dbo.Dimension_Table_Metadata;
GO

INSERT INTO dbo.Dimension_Table_Metadata
	(Target_Dimension_Table_Name, Source_Fact_Schema_Name, Source_Fact_Table_Name, Source_Fact_Column_Name)
VALUES
	('Dim_Department_GroupName', 'HumanResources', 'Department', 'GroupName'),
	('Dim_JobTitle', 'HumanResources', 'Employee', 'JobTitle'),
	('Dim_PersonType', 'Person', 'Person', 'PersonType'),
	('Dim_ProductColor', 'Production', 'Product', 'Color'),
	('Dim_ProductInventoryShelf', 'Production', 'ProductInventory', 'Shelf'),
	('Dim_TransactionType', 'Production', 'TransactionHistory', 'TransactionType')
GO
	
IF EXISTS (SELECT * FROM sys.procedures WHERE procedures.name = 'Generate_Dimension_Tables')
BEGIN
	DROP PROCEDURE dbo.Generate_Dimension_Tables
END
GO

CREATE PROCEDURE dbo.Generate_Dimension_Tables
AS
BEGIN
	SET NOCOUNT ON;

	DECLARE @Sql_Command NVARCHAR(MAX) = '';
	SELECT @Sql_Command = @Sql_Command + '
		USE AdventureWorks2016;

		IF EXISTS (SELECT * FROM sys.tables INNER JOIN sys.schemas ON schemas.schema_id = tables.schema_id WHERE tables.name = ''' + Dimension_Table_Metadata.Target_Dimension_Table_Name + ''' AND schemas.name = ''' + Dimension_Table_Metadata.Source_Fact_Schema_Name + ''')
		BEGIN
			DROP TABLE [' + Dimension_Table_Metadata.Source_Fact_Schema_Name + '].[' + Dimension_Table_Metadata.Target_Dimension_Table_Name + '];
		END

		CREATE TABLE [' + Dimension_Table_Metadata.Source_Fact_Schema_Name + '].[' + Dimension_Table_Metadata.Target_Dimension_Table_Name + ']
		(	[' + Dimension_Table_Metadata.Target_Dimension_Table_Name + '_Id] INT NOT NULL IDENTITY(1,1) CONSTRAINT [PK_' + Dimension_Table_Metadata.Target_Dimension_Table_Name + '] PRIMARY KEY CLUSTERED,
			[' + Dimension_Table_Metadata.Source_Fact_Column_Name + '] ' + USERDATATYPE.name +
			CASE WHEN USERDATATYPE.name IN ('char', 'nchar', 'nvarchar', 'varchar') THEN 
				'(' + 
					CASE WHEN columns.max_length = -1 THEN 'MAX'
							WHEN USERDATATYPE.name IN ('char', 'varchar') THEN CAST(columns.max_length AS VARCHAR(MAX))
							ELSE CAST(columns.max_length / 2 AS VARCHAR(MAX))
					END	+ ')'
			ELSE '' END + ' NOT NULL);

		INSERT INTO [' + Dimension_Table_Metadata.Source_Fact_Schema_Name + '].[' + Dimension_Table_Metadata.Target_Dimension_Table_Name + ']
			([' + Dimension_Table_Metadata.Source_Fact_Column_Name + '])
		SELECT DISTINCT
			' + Dimension_Table_Metadata.Source_Fact_Table_Name + '.' + Dimension_Table_Metadata.Source_Fact_Column_Name + '
		FROM [' + Dimension_Table_Metadata.Source_Fact_Schema_Name + '].[' + Dimension_Table_Metadata.Source_Fact_Table_Name + ']
		WHERE ' + Dimension_Table_Metadata.Source_Fact_Table_Name + '.' + Dimension_Table_Metadata.Source_Fact_Column_Name + ' IS NOT NULL;'
	FROM dbo.Dimension_Table_Metadata
	INNER JOIN sys.tables
	ON tables.name = Dimension_Table_Metadata.Source_Fact_Table_Name
	INNER JOIN sys.columns
	ON tables.object_id = columns.object_id
	AND columns.name COLLATE database_default = Dimension_Table_Metadata.Source_Fact_Column_Name
	INNER JOIN sys.schemas
	ON schemas.schema_id = tables.schema_id
	AND schemas.name = Dimension_Table_Metadata.Source_Fact_Schema_Name
	INNER JOIN sys.types USERDATATYPE
	ON columns.user_type_id = USERDATATYPE.user_type_id
	INNER JOIN sys.types SYSTEMDATATYPE
	ON SYSTEMDATATYPE.user_type_id = USERDATATYPE.system_type_id
	WHERE (	  USERDATATYPE.name IN ('char', 'nchar', 'nvarchar', 'varchar')
		   OR SYSTEMDATATYPE.name IN ('char', 'nchar', 'nvarchar', 'varchar'));
	
	EXEC sp_executesql @Sql_Command;
END
GO

EXEC dbo.Generate_Dimension_Tables;
GO

/*
SELECT
	schemas.name AS SchemaName,
	tables.name AS TableName,
	columns.name AS ColumnName,
	CASE
		WHEN columns.max_length = -1 THEN 'MAX'
		WHEN types.name IN ('char', 'varchar') THEN CAST(columns.max_length AS VARCHAR(MAX))
		ELSE CAST(columns.max_length / 2 AS VARCHAR(MAX))
	END AS ColumnSize,
	types.name AS TypeName
FROM sys.tables
INNER JOIN sys.columns
ON tables.object_id = columns.object_id
INNER JOIN sys.schemas
ON schemas.schema_id = tables.schema_id
INNER JOIN sys.types
ON columns.user_type_id = types.user_type_id
WHERE types.name IN ('char', 'nchar', 'nvarchar', 'varchar')
ORDER BY schemas.name, tables.name, columns.name;
*/